//
//  MCIPAddress.h
//  MCHosting
//
//  Created by Thomas Bartelmess on 10-08-30.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#include <arpa/inet.h> 

extern NSString * kinvalidIPv4Address;
extern NSString * kinvalidIPv6Address;
extern NSString * kIPv4LoopbackAddress;
extern NSString * kIPv6LoopbackAddress;

typedef enum {
	MCIPAddressTypeIPv4,
	MCIPAddressTypeIPv6,
} MCIPAddressType;
@interface MCIPAddress : NSObject {
	struct sockaddr_in v4Address;
	struct sockaddr_in6 v6Address;
	MCIPAddressType addressType;
}
- (id)initWithIPAddress:(NSString *)ipaddress;
- (MCIPAddressType)ipAddressType;
- (BOOL)isLoopback;
- (NSString *)stringRepresentation;

@end
